from machine import Pin,PWM
import neopixel
import random
from utime import sleep
button = Pin(18, Pin.IN)
RGB_pin = Pin(25, Pin.OUT)

np = neopixel.NeoPixel(RGB_pin, n=4, bpp=3, timing=1)
speed =1023
def setup():  
    for i in range(0,4):
        np[i] = (0,0,0)
    np.write()
    
def motor(L12,L13,R14,R15):
    PWM(Pin(12)).duty(L12) 
    PWM(Pin(13)).duty(L13) 
    PWM(Pin(14)).duty(R14) 
    PWM(Pin(15)).duty(R15)
    
def loop():
    while button.value() == 1:
        pass
    else:
        while True:
            for t in range(0,5):
                for n in range(0,4):
                    motor(0,speed,speed,0)
                    rgb_red = random.randint(0,256)
                    rgb_green = random.randint(0,256)
                    rgb_blue = random.randint(0,256)
                    np[n] = (rgb_red,rgb_green,rgb_blue)
                    np.write()
                    sleep(0.05)
                    np[n] = (0,0,0)
                    np.write()
                    sleep(0.05)
                    
            for t in range(0,5):
                for n in range(0,4):
                    motor(speed,0,0,speed)
                    rgb_red = random.randint(0,255)
                    rgb_green = random.randint(0,255)
                    rgb_blue = random.randint(0,255)
                    np[n] = (rgb_red,rgb_green,rgb_blue)
                    np.write()
                    sleep(0.05)
                    np[n] = (0,0,0)
                    np.write()
                    sleep(0.05)

if __name__ == "__main__":
    setup()
    loop()

